/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.serialize;

import io.gitlab.jfronny.commons.serialize.emulated.DataElement;
import java.util.Map;
import net.fabricmc.loader.api.metadata.CustomValue;

public class FabricLoaderDataMapper {
    public static DataElement toGson(CustomValue customValue) {
        if (customValue == null) {
            return null;
        }
        return switch (customValue.getType()) {
            default -> throw new MatchException(null, null);
            case CustomValue.CvType.OBJECT -> {
                DataElement.Object jo = new DataElement.Object();
                for (Map.Entry value : customValue.getAsObject()) {
                    jo.members().put((String)value.getKey(), FabricLoaderDataMapper.toGson((CustomValue)value.getValue()));
                }
                yield jo;
            }
            case CustomValue.CvType.ARRAY -> {
                DataElement.Array jo = new DataElement.Array();
                for (CustomValue value : customValue.getAsArray()) {
                    jo.elements().add(FabricLoaderDataMapper.toGson(value));
                }
                yield jo;
            }
            case CustomValue.CvType.STRING -> new DataElement.Primitive.String(customValue.getAsString());
            case CustomValue.CvType.NUMBER -> new DataElement.Primitive.Number(customValue.getAsNumber());
            case CustomValue.CvType.BOOLEAN -> new DataElement.Primitive.Boolean(customValue.getAsBoolean());
            case CustomValue.CvType.NULL -> new DataElement.Null();
        };
    }
}

